

#ifndef  __TIMER_H__
#define  __TIMER_H__


#include <cstdint>
#include "interrupt.h"


extern "C++" {
	namespace avelino {
		using namespace std;

		class timer_listener_t {
			public:
				virtual void timer_expired() = 0;
		};

		uint64_t operator "" _ms_for_timer(unsigned long long v);

		uint64_t operator "" _us_for_timer(unsigned long long v);

		class timer_t {
			public:
				static uint64_t interval;
				static timer_listener_t *listener;
				static void init(timer_listener_t &listener, uint64_t interval = 1000_ms_for_timer);
                static void interrupt()  __attribute__ ((interrupt, section(SYSTICK_INT_SECTION)));
		};
	}
}


#endif  // __TIMER_H__
