

#include "timer.h"


using namespace avelino;
using namespace std;


#define  STK_CTLR   *((uint32_t *) 0xE000F000)
#define  STK_SR     *((uint32_t *) 0xE000F004)
#define  STK_CNTR   *((uint32_t *) 0xE000F008)
#define  STK_CMPR   *((uint32_t *) 0xE000F010)


uint64_t timer_t::interval = 8000000ULL;
timer_listener_t *timer_t::listener = nullptr;


uint64_t avelino::operator "" _ms_for_timer(unsigned long long v) {
	return ((uint64_t) 8000) * v;
}


uint64_t avelino::operator "" _us_for_timer(unsigned long long v) {
	return ((uint64_t) 8) * v;
}


void timer_t::init(timer_listener_t &listener, uint64_t interval) {
	timer_t::listener = &listener;
	timer_t::interval = interval;
	STK_CTLR = 0;                 // stop systick counter
	STK_CNTR = 0;
	STK_CMPR = interval;   // compare value 2000000 to trig systick every 1/4 second at 8 MHz
	STK_CTLR = 0x0000000F;        // count until compare value, enable interrupts, base freq is HCLK (8 MHz) and start counter
	PFIC_ENABLE(SYSTICK_INT);     // enable systick on PFIC
}


void timer_t::interrupt() {
	if (timer_t::listener != nullptr)
		timer_t::listener->timer_expired();
	STK_SR = 0;     // clear systick interrupt flag
}

