

#include <stdint.h>


using namespace std;


extern "C" {
	extern void (*__CTOR_LIST__)();
	extern void (*__DTOR_LIST__)();
	extern void (*__init_array_start)();
	extern void (*__init_array_end)();
	extern void (*__fini_array_start)();
	extern void (*__fini_array_end)();
}


void _callInitArray() {
	void (**f)() = &__init_array_start;
	while (f != &__init_array_end) {
		(*f)();
		f++;
	}
}


void _callConstructors() {
	void (**constructor)() = &__CTOR_LIST__;
	uint32_t total = *(uint32_t *) constructor;
	constructor++;
	while (total) {
		(*constructor)();
		total--;
		constructor++;
	}
}


void _callDestructors() {
	void (**destructor)() = &__DTOR_LIST__;
	uint32_t total = *(uint32_t *) destructor;
	destructor++;
	while (total) {
		(*destructor)();
		total--;
		destructor++;
	}
}


void _callFiniArray() {
	void (**f)() = &__fini_array_start;
	while (f != &__fini_array_end) {
		(*f)();
		f++;
	}
}


void _initClock() {
	// TODO
    // no code, so HSI 24 MHz clock used
}


extern int main();


extern "C" {
	extern unsigned char flash_sdata;
	extern unsigned char ram_sdata;
	extern unsigned char ram_edata;
}


void _initDataRAM() {
	// init .data section (global variables) with flash data
	unsigned char *from = &flash_sdata;
	unsigned char *to = &ram_sdata;
	while (to != &ram_edata) {
		*to = *from;
		from++;
		to++;
	}
}


extern "C" {
	extern unsigned char ram_sbssdata;
	extern unsigned char ram_ebssdata;
}


void _initBssRAM() {
	// init .bss section with zeros
	unsigned char *p = &ram_sbssdata;
	while (p != &ram_ebssdata) {
		*p = 0;
		p++;
	}
}


void _startup_0() __attribute__((section(".startup0"), naked));   // startup located at begining of flash
void _startup_1() __attribute__((section(".startup1"), naked));   // rest of startup


void _startup_0() {
	asm volatile (
		"j %0" : : "i" (_startup_1)
	);
}


void _startup_1() {
	asm volatile (
		"la sp, 0x20000800"     // point SP to the end of SRAM
	);
	_initClock();
	_initDataRAM();
	_initBssRAM();
	_callConstructors();
	_callInitArray();
	main();
	_callFiniArray();
	_callDestructors();
	while (true)
		;
}


extern "C" void __cxa_pure_virtual() {}
void *__dso_handle = 0;
extern "C" void __cxa_atexit() {}

