

#include <stdint.h>
#include "interrupt.h"
#include "timer.h"
#include "led_block.h"
#include "lfsr.h"


/*
    Xmas stars emulator.
    Connect 8 leds to: C5, C6, C7, D2, D3, D4, D5 and D6 pins
*/
using namespace std;
using namespace avelino;


class my_timer_listener_t : public timer_listener_t {
    protected:
        lfsr_t lfsr;
    public:
        my_timer_listener_t();
        virtual void timer_expired();
};


my_timer_listener_t::my_timer_listener_t() {
    led_block_t::init();
}


void my_timer_listener_t::timer_expired() {
    this->lfsr.iterate();
    led_block_t::set(this->lfsr.reg);
}


int main() {
    interrupt_init();
    my_timer_listener_t my_timer_listener;
    timer_t::init(my_timer_listener, 1000_ms_for_timer);
	while (true)
		asm volatile ("wfi");
}
