

#include "led_block.h"


using namespace std;
using namespace avelino;


#define  RCC_APB2PCENR  *((uint32_t *) 0x40021018)
#define  GPIOC_CFGLR    *((uint32_t *) 0x40011000)
#define  GPIOD_CFGLR    *((uint32_t *) 0x40011400)
#define  GPIOC_OUTDR    *((uint32_t *) 0x4001100C)
#define  GPIOD_OUTDR    *((uint32_t *) 0x4001140C)


void led_block_t::init() {
    RCC_APB2PCENR |= ((uint32_t) 3) << 4;   // enable clock on ports C and D
    GPIOC_CFGLR = (GPIOC_CFGLR & 0x000FFFFF) | 0x22200000;    // C5, C6 and C7 = output push-pull
    GPIOD_CFGLR = (GPIOD_CFGLR & 0xF00000FF) | 0x02222200;    // D2, D3, D4, D5 and D6 = output push-pull
}


const uint32_t LED_PORTS[] = {
    0x4001100C,
    0x4001100C,
    0x4001100C,
    0x4001140C,
    0x4001140C,
    0x4001140C,
    0x4001140C,
    0x4001140C
};


const uint8_t LED_BITS[] = {
    5, 6, 7, 2, 3, 4, 5, 6
};


void led_block_t::set(uint8_t v) {
    const uint32_t *p_addr = LED_PORTS;
    const uint8_t *p_bits = LED_BITS;
    uint8_t n = 8;
    do {
        if ((v & 1) != 0)
            *((uint32_t *) *p_addr) |= ((uint8_t) 1) << *p_bits;
        else
            *((uint32_t *) *p_addr) &= ~(((uint8_t) 1) << *p_bits);
        p_addr++;
        p_bits++;
        v >>= 1;
        n--;
    } while (n > 0);
}

